<%--
 This is an error page delivered by the TaskInterface servlet when the user
 appears to have interacted with a page in the browser's history.  Its job
 is to display a brief warning message instructing them not to do that, then
 redirect the browser to a URL that will show the current panel for that task.
--%>

<%@taglib prefix="c" uri="http://java.sun.com/jstl/core"%>
<%@taglib prefix="fmt" uri="http://java.sun.com/jstl/fmt"%>

<fmt:bundle basename="com.ibm.hwmca.fw.servlet.tasks.res.task">
<html>
<head>
   <title><fmt:message key="historyWarningTitle"/></title>
   <link href="/wclres/WclBaseSkinCSS.css" rel="stylesheet" type="text/css"/>
   <link rel="SHORTCUT ICON" href="/favicon.ico"/>
   <link rel="icon" href="/hmc.png" type="image/png"/>

   <meta http-equiv="refresh" content="4;URL=<c:out value='${taskURI}'/>"/>
</head>
<body>
<span class="wclContainer">
<h1><fmt:message key="historyWarningTitle"/></h1>
<p><fmt:message key="historyWarningMessage"/></p>
</span>

<script type="text/javascript">
   // Make sure the request came from the right window.  If not, close the window.
   if (window.name != "<c:out value='${expectedWindowName}'/>") {
      window.onunload = "";
      window.close();

   } else {
      // Make sure the message can be read
      window.resizeTo(<fmt:message key="historyWindowWidth"/>,
                      <fmt:message key="historyWindowHeight"/>);
   }
</script>
</body>
</html>
</fmt:bundle>
